<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Admin\PermissionController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\HomeController;
use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Admin\MediaController;
use App\Http\Controllers\Admin\TagController;
use App\Http\Controllers\Admin\BlogController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\ContactController;
use App\Http\Controllers\Admin\LogisticController;
use App\Http\Controllers\Admin\PeopleController;
use App\Http\Controllers\Admin\SeoController;
use App\Http\Controllers\Admin\ChangePasswordController;
use App\Http\Controllers\Admin\ContactusController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Front\IndexController;





/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/




Auth::routes();



Route::middleware(['auth'])->group(function(){

	Route::group(['prefix' =>'/admin/'],function(){
	
		Route::get('/', [HomeController::class, 'index']);
		

	Route::post('/page/status/{id}',[PageController::class,'status']);
	Route::post('/media/status/{id}',[MediaController::class,'status']);
	Route::post('/blog/status/{id}',[BlogController::class,'status']);
	Route::post('/people/status/{id}',[PeopleController::class,'status']);
	Route::post('/tag/status/{id}',[TagController::class,'status']);
	
    
	Route::get('/admin/down',function(){
		Artisan::call('down');
 
	});

	
     Route::get('/profile', [HomeController::class,'show']);
     Route::get('/profilechange', [HomeController::class,'changeprofile']);
     Route::put('/profile/update/{user}',[HomeController::class,'updateprofile']);

	Route::get('/change-password', [ChangePasswordController::class, 'index'])->name('change.password');
	Route::post('/change-password', [ChangePasswordController::class, 'store'])->name('change.password');
	
	Route::resource('/page',PageController::class);
	Route::resource('/media',MediaController::class);
	Route::resource('/category',CategoryController::class);
	Route::resource('/tag',TagController::class);
	Route::resource('/blog',BlogController::class);
	Route::resource('/setting',SettingController::class);
	Route::resource('/people',PeopleController::class);
	Route::resource('/logistic',LogisticController::class);
	Route::resource('/contact',ContactController::class);
	Route::resource('roles', RoleController::class);
	Route::resource('users', UserController::class);
	Route::resource('permissions', PermissionController::class);
	Route::resource('/contactus',ContactusController::class);
	Route::resource('/seo',SeoController::class);
	
});	
});


Route::get('/page',function(){
return view('front.pages.index');
});

Route::get('/blog',function(){

return view('front.pages.blog');
});

Route::get('/detail',function(){

return view('front.pages.blog_detail');
});



	
Route::get('/contact',[IndexController::class,'contact']);
Route::group(['prefix' =>'/'],function(){
    
Route::get('/',[IndexController::class,'index']);

Route::post('/create',[IndexController::class,'store']);

Route::get('/search',[IndexController::class,'search'])->name('search');

Route::get('/pages/{subchild_slug}',[IndexController::class,'subchild_page'])->name('subchild.page');


Route::get('/about/{slug}',[IndexController::class,'readabout'])->name('readabout');
Route::get('/{slug}',[IndexController::class,'subservices'])->name('page.slug');
Route::get('/tags/{tag}',[IndexController::class,'tags'])->name('tags.group');

Route::get('/support/{subchild_slug}',[IndexController::class,'support'])->name('page.support');

Route::get('/blog-detail/{slug}',[IndexController::class,'blog_detail'])->name('blog.detail');
Route::get('/category/{id}',[IndexController::class,'categorydetail'])->name('category.slug');


});




Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');